/* eslint-disable no-param-reassign */
import React from 'react';
import PropTypes from 'prop-types';
import { Menu, Breadcrumb, Icon } from 'antd';
import { connect } from 'dva';
import { Link } from 'dva/router';
import styles from './header.less';
import { makePath } from '../../utils/helper';

const SubMenu = Menu.SubMenu;

const normRoutes = (routes) => {
  if (routes && routes.length > 0) {
    const out = [];
    let base = '/';
    for (let i = 0; i < routes.length; ++i) {
      const route = routes[i];
      if (route.path) {
        base = makePath(base, route.path, false);
        if (out.length === 0 || out[out.length - 1].path !== base) {
          out.push({ ...route, path: base });
        }
      }
    }
    return out;
  }
  return routes;
};

// const makeRelativePath = (base, path) => {
//   if (path === undefined || path === null || !base || !base.startsWith('/')) {
//     throw new Error(`Invalid arguments: '${base}' / '${path}'`);
//   }
//   if (!path.startsWith('/')) {
//     return path;
//   }
//   if (!base.endsWith('/')) {
//     base = `${base}/`;
//   }
//   if (base.length > path.length) {
//     if (base === `${path}/`) {
//       return '';
//     }
//     throw new Error(`Invalid arguments: '${base}' / '${path}'`);
//   }
//   if (path.startsWith(base)) {
//     return path.slice(base.length);
//   }
//   throw new Error(`Invalid arguments: '${base}' / '${path}'`);
// };
//
// const normRoutes2 = (routes) => {
//   if (routes && routes.length > 0) {
//     const out = [];
//     let base = '/';
//     for (let i = 0; i < routes.length; ++i) {
//       const route = routes[i];
//       const path = route.path || '';
//       const newBase = makePath(base, path);
//       if (out.length === 0 || out[out.length - 1].path !== newBase) {
//         if (path === '/') {
//           out.push(route);
//         } else {
//           out.push({ ...route, path: makeRelativePath(base, path) });
//         }
//       }
//       base = newBase;
//     }
//     return out;
//   }
//   return routes;
// };

class HeaderPane extends React.Component {

  componentDidMount() {
    const { dispatch } = this.props;
    dispatch({ type: 'main/fetchUser' });
    dispatch({ type: 'main/fetchDomain' });
    dispatch({ type: 'main/fetchDomains' });
  }
  render() {
    const { dispatch, user, domain, domainList, routes, params } = this.props;
    const nRoutes = normRoutes(routes);
    const userTitle = (
      <span>
        <Icon type="user" />
        { user }
      </span>
    );
    const domainTitle = (
      <span>
        <Icon type="home" />
        { domain }
      </span>
    );
    const onClick = ({ keyPath }) => {
      if (keyPath[1] === 'user' && keyPath[0] === 'logout') {
        dispatch({ type: 'main/logout' });
      } else if (keyPath[1] === 'domain') {
        dispatch({ type: 'main/switchDomain', payload: keyPath[0] });
      }
    };
    const joinPath = (paths) => {
      if (paths && paths.length > 0) {
        // eslint-disable-next-line
        return `/${paths[paths.length - 1]}`;
      }
      return '/';
    };
    const breadsProps = {
      className: styles.breads,
      routes: nRoutes,
      params,
      itemRender(route, _params, _routes, paths) {
        if (!paths || !paths.length) {
          return null;
        }
        if (paths.length === 1) {
          return <Icon type="home" />;
        }
        const bread = route.name ? route.name : route.path;
        return <Link to={joinPath(paths)}>{ bread }</Link>;
      },
    };
    const menuProps = {
      className: styles.menu,
      mode: 'horizontal',
      theme: 'light',
      selectable: false,
      onClick,
    };
    return (
      <div className={styles.board}>
        <Breadcrumb {...breadsProps} />
        <Menu {...menuProps}>
          <SubMenu title={userTitle} key="user" >
            <Menu.Item key="logout">
              <span>
                <Icon type="logout" />
                登出
              </span>
            </Menu.Item>
          </SubMenu>
          <SubMenu title={domainTitle} key="domain">
            {
              domainList.map(dm => (
                <Menu.Item key={dm.path}>
                  { dm.name }
                </Menu.Item>
              ))
            }
          </SubMenu>
        </Menu>
      </div>
    );
  }
}

HeaderPane.propTypes = {
  dispatch: PropTypes.func,
  user: PropTypes.string,
  domain: PropTypes.string,
  domainList: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.number,
    name: PropTypes.string,
  })),
};

const mapStateToProps = ({ main }) => {
  return {
    user: main.user,
    domain: main.domain,
    domainList: main.domainList,
  };
};

export default connect(mapStateToProps)(HeaderPane);

