# 登录与认证

登录分为2个步骤。
第一步通过用户名或其他用户标识符确定用户的存在性，
并获得一个未认证的token（令牌）。
同时返回的还有该用户需要经过哪些认证方式才能真正登录。
第二步使用上一步获得的令牌，并根据给予的验证需求，使用对应的方式予以认证。
所有验证需求都验证通过后，才正式登录成功，并且token变为有效。
之后所有的api调用都会用到此token。

## 获取一个未验证token

- **URL**:
/api/auth/login

- **Method**:
POST

- **Accept**: application/json

  ```
  {
    type: string,
    data: string,
    tokenInfo: {
      productId: string,
      deviceId: string
    },
    authRequest: {
      type: string,
      parameters: Map
    }
  }
  ```

  - *type* - **string** 登录方式, 可选值为`userName`，`email`，分别表示用户名登录和邮箱登录。
  - *data* - **string** 登录方式对应的登录数据, `userName`对应的登录数据即为用户名，`email`对应的登录数据即为邮箱地址
  - *tokenInfo* - **object** 登录必备的信息，为权限验证所需。
    - *productId* - **string** 产品ID，表示要登录的产品。
    - *deviceId* - **string** 设备ID，一条可以用来唯一标识客户端的字符串，生成规则不限，只要保证唯一性和不变性即可。
  - *authRequest* - **object** 验证请求，为了简化接口，登录的同时也可以一起进行验证。
    前提是事先知道对应用户需要用哪种方式进行验证。因为用户所需的验证方式是后台可配置，
    不是一成不变的，所以不建议登录验证同时进行的api调用方式。
    - *type* - **string** 验证方式。可选值为`password`，表示密码登录
    - *parameters* - **object** 验证参数。`password`对应的验证参数为
      `{ cipher: string }`，表示用户密码。
    
- **Content-Type**:
application/json

  - *tokenId* - **string** 未加密的原始token字符串，该token在服务器存在内存中，
    若超过30分钟没有使用该token，该token将失效。
  - *authResponse* - **object** 验证响应，请求体中包含`authRequest`字段时，响应体中才会有此字段。
    - *type* - **string** 验证类型，与请求体中`authRequest.type`值相同。
    - *status* - **string** 验证状态，可能值为：`authed`,`rejected`,`skipped`等。
      `authed`表示验证通过，`rejected`表示验证未通过，`skipped`表示不需要此步验证。
      以上3种可能值为所有验证方式共有。其他可能值依赖于各自的验证方式。
    - *data* - **any** 验证响应数据。其含义依赖于验证方式。
    - *remainedAuthRequirements* - **object** 剩余的验证需求。
      - *requirements* - **[object]** 若干个验证需求，逻辑关系为和。
        若为空数组，表示所有验证需求均已满足，即全部验证成功。
        - *authTypes*: - **[string]** 若干个验证方式，逻辑关系为或，
          只要其中一个验证方式验证成功，该验证条件即满足。
  - *remainedAuthRequirements* - **object** 同`authResponse.remainedAuthRequirements`。
    不同之处在于请求体中不需要包含`authRequest`，该字段也存在。

  ```
  {
    tokenId: string,
    authResponse: {
      type: string,
      status: string,
      data: any,
      remainedAuthRequirements: {
        requirements: [{
          authTypes: [string]
        }]
      }
    },
    remainedAuthRequirements: {  
      requirements: [{
        authTypes: [string]
      }]
    }
  }
  ```
  
- **note**:

  获取后的token，不能直接使用，需要使用公钥进行非对称加密。加密方式如下：
  1. 直接使用token，或包装成令牌对象：
     ```
     {
       tkId: string, //令牌
       ett: long, //令牌发出时间，从1970/1/1 UTC至今的毫秒数
       life: long //令牌对象有效期，单位毫秒
     }
     ```
  2. 将token字符串本身或包装成的令牌对象的json字符串表示转为utf-8字节数组。
  3. 使用给定公钥，以**RSA/None/PKCS1Padding**方式进行加密。然后对加密结果进行base64urlsafing方式转码
     （先进行普通的base64转码，然后去除尾部'='，然后用'-'替换所有'+'，用'_'替换所有'/'）
- **公钥**:
 
  `-----BEGIN PUBLIC KEY-----MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC+/Rs6dYmdtETjHCZq4LF3QjLM/DocRAXrqtMULZf+579dAn+CiM8noLplZT/DRwvfK822eq8sypH+a4NqP7942pPVjOudVvKfiJvmm2TOQHvQ7vi3iyZVdlsxX72JNFo1Ocqwj48aIC/OJ4bMf/VyCKrmKrU2iXND+I4BN8cfhwIDAQAB-----END PUBLIC KEY-----`

## 验证token

- **URL**:
/api/auth/authorize

- **Method**:
POST

- **Accept**:
application/json

  ```
  {
    tkId: string,
    request: {
      type: string, //验证方式
      parameters: Map //验证参数
    }
  }
  ```
  - *tkId* - **string** 加密后的令牌
  - *request* -**object** 验证请求
     - *type* - **string** 验证方式。可选值为`password`，表示密码登录
     - *parameters* - **object** 验证参数。`password`对应的验证参数为
        `{ cipher: string }`，表示用户密码。

- **Content-Type**:
application/json

  ```
  {
    type: string,
    status: string,
    data: any,
    remainedAuthRequirements: {
      requirements: [{
        authTypes: [string]
      }]
    }
  }
  ```
  - *type* - **string** 验证类型，与请求体中`authRequest.type`值相同。
  - *status* - **string** 验证状态，可能值为：`authed`,`rejected`,`skipped`等。
    `authed`表示验证通过，`rejected`表示验证未通过，`skipped`表示不需要此步验证。
    以上3种可能值为所有验证方式共有。其他可能值依赖于各自的验证方式。
  - *data* - **any** 验证响应数据。其含义依赖于验证方式。
  - *remainedAuthRequirements* - **[object]** 剩余的验证需求。
    - *requirements* - **[object]** 若干个验证需求，逻辑关系为和。
      若为空数组，表示所有验证需求均已满足，即全部验证成功。
      - *authTypes* - **[string]** 若干个验证方式，逻辑关系为或，
        只要其中一个验证方式验证成功，该验证条件即满足。
        
## 登出

- **URL**:
/api/auth/logout

- **Method**:
POST

- **Accept**:
application/json
  - `empty` - 只包含前置说明中提到的token，即`{ token: string }`， 之后不再重复说明。

- **Content-Type**: 
application/json

  `null` - 并不是真正的空，仅仅是如前置说明中提到那样，`data`字段为`null`， 之后不再重复说明。
