import React from 'react';
import PropTypes from 'prop-types';
import cs from 'classnames';
import hljs from 'highlight.js/lib/highlight';
import langJson from 'highlight.js/lib/languages/json';
import langJavascript from 'highlight.js/lib/languages/javascript';
import 'highlight.js/styles/github.css';

hljs.registerLanguage('json', langJson);
hljs.registerLanguage('javascript', langJavascript);

class Code extends React.Component {
  componentDidMount() {
    this.highlightCode();
  }
  componentDidUpdate() {
    this.highlightCode();
  }
  setRef = (el) => {
    this.codeEl = el;
  };
  highlightCode = () => {
    hljs.highlightBlock(this.codeEl);
  };

  render() {
    return (
      <pre>
        <code
          ref={this.setRef}
          className={cs({
            [`language-${this.props.language}`]: !!this.props.language,
          })}
        >
          { this.props.value }
        </code>
      </pre>
    );
  }
}

Code.propTypes = {
  value: PropTypes.string.isRequired,
  language: PropTypes.string,
};

Code.defaultProps = {
  language: '',
};

export default Code;
