# 录入房源

录入、更新房源数据。在选房之前，房子数据要进入系统。系统中房源以房源编号（number）为唯一标识。

## 接口名称

importFangYuan

>## 用法

- **URL：**/api/interface/user/importFangYuan/invoke

- **Method:** Post
> **Note:** Domain 必须切换到基地这一作用域,切换作用域，参照“作用域”部分

## 参数

- **token:**  token是在登陆后获取的tokenId，加密后的结果。
- **dmPath:** 作用域路径 例如 "/XH/XH2018003/XH2018003-01"，/XH 代表徐汇区，/XH/XH2018003代表某个项目，其中XH2018003 是项目编号
- **params:**
  - **data**  是FangYuan的数据
  - **bindPath**  把房子绑定到某个项目中.

```json
[{
    number:string,-------------------------------房源编号（主键，必须唯一）
    type:string,---------------------------------房源类别
    nature:string,-------------------------------性质
    peiTao:string,-------------------------------是否配套
    qiOrXian:string,-----------------------------期房现房
    laiYuan:string,------------------------------来源
    huXing:string,-------------------------------户型
    taoXing:string,------------------------------套型
    jieGou:string,-------------------------------房源结构
    usage:string,--------------------------------用途
    yuCeMianJi:double,---------------------------预测面积
    yuCeYangTaiMianJi:double,--------------------预测阳台面积
    shiCeMianJi:double,--------------------------实测面积
    shiCeYangTaiMianJi:double,-------------------实测阳台面积
    sheJiMianJi:double,--------------------------设计面积
    sheJiYangTaiMianJi:double,-------------------设计阳台面积
    usedAreaType:string,-------------------------使用面积类型
    usedArea:double,-----------------------------使用面积
    danJia:double,-------------------------------单价
    youHuiDanJia:double,-------------------------优惠单价
    zongJia:double,------------------------------房屋总价
    youHuiZongJia:double,------------------------优惠总价
    shiCeZongJia:double,-------------------------实测总价
    district:string,-----------------------------所属区域
    subDistrict:string,--------------------------街道名
    community:string,----------------------------小区名称
    lane:string,---------------------------------弄
    building:string,-----------------------------幢、栋
    unit:string,---------------------------------单元
    no:string,-----------------------------------号
    floor:string,--------------------------------楼层
    room:string,---------------------------------室号
    contractNumber:,-----------------------------联系电话
    diKuai:string,-------------------------------地块名称
    address:string,------------------------------地址
    jinHuRiQi:date,------------------------------进户日期
    yuJiJiaoFangRiQi:date,-----------------------预计交房日期
    shiJiJiaoFangRiQi:date,----------------------实际交房日期
}]
```

## 返回值

无

## 例子

```json
{
    "token": "RNZWJeF2n5pOlLPuHr8xFZNT5sH3HMEmD75axJ_n17swh6yv-oRV1Jr3GRhn1gLWpGGtQYvC9r9-yBteXmg-qDxp2Ln70R9gBEMo95vxcHShLPNWTp3USqUglRs2XqHKQrToyw5pwBjJsv_UxZzrT30DQPsr07cemMi99QBXVYY",
    "dmPath": "/XH/XH2018003/XH2018003-01",
    "params": {
        "data": [
            {
                "anZhiMianJi": 0,
                "building": "",
                "community": "",
                "danJia": 3400,
                "district": "浦东新区",
                "floor": "",
                "huXing": "",
                "jieGou": "",
                "laiYuan": "",
                "lane": "",
                "nature": "",
                "no": "",
                "number": "cs-005",
                "peiTao": "",
                "qiOrXian": "期房",
                "room": "",
                "sheJiMianJi": 0,
                "sheJiYangTaiMianJi": 0,
                "shiCeMianJi": 0,
                "shiCeYangTaiMianJi": 0,
                "shiCeZongJia": 0,
                "shiJiJiaoFangRiQi": "0001/01/01",
                "subDistrict": "",
                "taoXing": "中套",
                "unit": "",
                "usedArea": 85.12,
                "usedAreaType": "预测面积",
                "youHuiDanJia": 0,
                "youHuiZongJia": 0,
                "yuCeMianJi": 0,
                "yuCeYangTaiMianJi": 0,
                "yuJiJiaoFangRiQi": "1900/01/01",
                "zongJia": 0
            },
            {
                "anZhiMianJi": 0,
                "building": "",
                "community": "",
                "danJia": 3400,
                "district": "浦东新区",
                "floor": "",
                "huXing": "",
                "jieGou": "",
                "laiYuan": "",
                "lane": "",
                "nature": "",
                "no": "",
                "number": "cs-012",
                "peiTao": "",
                "qiOrXian": "期房",
                "room": "",
                "sheJiMianJi": 0,
                "sheJiYangTaiMianJi": 0,
                "shiCeMianJi": 0,
                "shiCeYangTaiMianJi": 0,
                "shiCeZongJia": 0,
                "shiJiJiaoFangRiQi": "0001/01/01",
                "subDistrict": "",
                "taoXing": "小大套",
                "unit": "",
                "usedArea": 96.51,
                "usedAreaType": "预测面积",
                "youHuiDanJia": 0,
                "youHuiZongJia": 0,
                "yuCeMianJi": 0,
                "yuCeYangTaiMianJi": 0,
                "yuJiJiaoFangRiQi": "1900/01/01",
                "zongJia": 0
            }
        ],
        "bindPath": "/XH/XH2018003/XH2018003-01"
    }
}
```