import React from 'react';
import cs from 'classnames';
import ReactMarkdown from 'react-markdown';
import { Spin } from 'antd';
import { AsyncComponent } from 'react-async-wrapper';
import { userApi } from '../../../../../services/interfaces';
import Code from '../code';
import styles from '../markdown.less';
import { processError } from '../../../../../utils/error';

const MarkDownWithLoading = ({ loading, source, height }) => (
  <Spin spinning={loading} style={{ height, maxHeight: height }}>
    <ReactMarkdown
      source={source}
      className={cs({
        'markdown-body': true,
        [styles.markdown]: true,
      })}
      renderers={{
        code: Code,
      }}
    />
  </Spin>
);

export default (match, infoes, size) => {
  const pathBase = `${match.path}/interface`;
  // return [
  //   ['addFamily', '新增两清'],
  //   ['addHouse', '新增房屋'],
  //   ['addPeople', '新增人口'],
  //   ['approveXieYi', '协议报审'],
  //   ['getClerks', '获取经办人'],
  //   ['getXieYiPdf', '获取协议pdf'],
  //   ['importFangYuan', '导入房源'],
  //   ['isLiangQingLocked', '查询两清是否锁定'],
  //   ['isXieYiApproved', '查询协议是否审核'],
  //   ['isXieYiLocked', '查询协议是否锁定'],
  //   ['lockLiangQing', '锁定两清'],
  //   ['lockXieYi', '锁定协议'],
  //   ['removeFamily', '删除两清'],
  //   ['removeFangYuan', '删除房源'],
  //   ['removeHouse', '删除房屋'],
  //   ['removePeople', '删除人口'],
  //   ['requestCancelXieYi', '申请撤销协议'],
  //   ['requestUnLockLiangQing', '申请解锁两清'],
  //   ['updateFamily', '更新两清'],
  //   ['updateHouse', '更新房屋'],
  //   ['updatePeople', '更新人口'],
  //   ['updateXieYi', '更新协议'],
  //   ['whetherCancelXieYi', '是否协议已撤销'],
  //   ['whetherUnLockLiangQing', '是否两清已解锁'],
  // ]
  return infoes.map(({ name, showName }) => ({
    name,
    showName: showName || name,
    key: `interface/${name}`,
    path: `${pathBase}/${name}`,
    // component: makeAsync({})(import(`./${name}.md`).then(content => content.default || content).then(md)),
    render: () => (
      <div style={{
        padding: 12,
        background: '#fafafa',
        width: '100%',
        height: size.height,
        overflow: 'scroll',
      }}
      >
        <AsyncComponent
          batch
          onError={processError}
          asyncProps={{
            source: async () => userApi.getInterfaceDocument(name),
          }}
        >
          <MarkDownWithLoading height={size.height - 24} />
        </AsyncComponent>
      </div>
    ),
  }));
};

