# 文件传输

本系统提供对小文件的存取功能。文件上传和文件的元信息的修改是分开进行的。
文件成功上传后会生成一个唯一的内部路径，用以唯一标识这个文件。

## 首次上传

### url

- **URL**:
/resource/{token}
  - *token* 加密后的令牌

- **Method**:
POST

- **Content-Type**: 
application/json
  - *uriList* - **[ string ]** 当上传成功时，返回所上传文件的系统内部路径，
  因为支持一次上传多个文件，所以返回的内部路径是个数组
  - **or** *error object* - **object** 当上传失败时，则返回这个错误对象。
    - *errorCode* - **long** 错误码
    - *message* - **string** 错误信息
    - *data* - **any** 错误相关数据

上传接口使用最普遍的multipart/form-data Post文件上传方式。
不同于其他接口，http包体的类型不再是application/json，而是multipart/form-data。
另一方面，加密的token也不再是放在包体中，而是直接拼接在url的路径中。
文件名若带后缀，系统支持自动根据后缀获取文件的媒体类型。


## 更新上传

### url

- **URL**:
/resource/{token}/{uri}
  - *token* 加密后的令牌
  - *uri* urlEncode过的系统内部路径

- **Method**:
POST

- **Content-Type**: 
application/json
  - *uriList* - **[ string ]** 当上传成功时，返回所上传文件的系统内部路径，
  因为支持一次上传多个文件，所以返回的内部路径是个数组
  - **or** *error object* - **object** 当上传失败时，则返回这个错误对象。
    - *errorCode* - **long** 错误码
    - *message* - **string** 错误信息
    - *data* - **any** 错误相关数据
    
替换之前上传的文件。基本和首次上传相同，但因为需要替换的文件的内部uri是拼接在url上的。
所以一次只能替换一个文件，不再像首次上传那样，支持多个文件。只有管理员和文件的拥有者有权更新文件。
首次上传文件的用户默认为文件的拥有者。

