# 前置说明

1. 接口的返回基本都是json格式，并且有如下形式: 
   ```
   {
     errorCode: long,
     data: any,
     message: string
   }
   ```
   - *errorCode*: 错误码，0表示成功，无错误
   - *data*: 真正的返回数据，后续文档如无特别说明，对于返回形式的描述都是指的data的格式。
               另外，发生错误时，这个字段也可能保护错误相关信息。
   - *message*: 错误消息，`errorCode`为0时，不使用这个字段。

2. 除了登录接口（获取token的接口），所有其他接口都要使用令牌（token）进行权限验证。
   token使用方式目前统一为: 
   - 若为GET或DELETE方法接口，token加密后作为query参数拼接在url上，参数名为token。
   - 若为POST方法接口，并且请求体是json格式的，若无特别说明，都保护一个token属性，值为加密后的token。
   - token的加密方式在登录部分会提及。
   
3. 绝大部分接口可接受`dmPath`参数。当接口是**GET**方法时，此参数作为查询参数拼接在url上。
   当接口是**POST**方法，并且请求体时json格式的，此参数作为一个顶级属性。
   参数`dmPath`可用来指定作用域路径。作用域在之后会详细提及。故此参数的作用也将会一同进行阐述。

3. 服务端使用fastjson进行json的解析，
   该框架支持循环引用的json序列化，
   并且对于json树中的同一个引用，
   可能会使用特殊的表示方式。具体见[循环引用](https://github.com/alibaba/fastjson/wiki/%E5%BE%AA%E7%8E%AF%E5%BC%95%E7%94%A8)。
   所以返回的json数据里部分属性可能以引用的形式存在。需要进一步解析。
   若使用java，可以用fastjson的[JSONPath](https://github.com/alibaba/fastjson/wiki/JSONPath)来进行解析。
   若使用javascript，可以用npm上的一个库[fastjson_ref_resolver](https://www.npmjs.com/package/fastjson_ref_resolver)来进一步处理。
