/* eslint-disable no-undef */
import React from 'react';
import { Spin, Tree } from 'antd';
import { connect } from 'dva';
import { Route, Switch, routerRedux } from 'dva/router';
import { makeAsync } from 'react-async-wrapper';
import 'github-markdown-css';
import { withSize } from '../../../../components/hoc/size';
import { userApi } from '../../../../services/interfaces';
import { processError } from '../../../../utils/error';
import styles from './index.less';
import mdIndex from './index.md';
import mdAuth from './auth.md';
import mdDomain from './domain.md';
import mdFile from './file.md';
import mdDyInt from './dynamic-interface/index.md';
import mdError from './error.md';
import createPages from './dynamic-interface';
import md from './markdown';

const TreeNode = Tree.TreeNode;

class DocMainPage extends React.PureComponent {
  onSelect = match => (ignored, e) => {
    const key = e.node.props.eventKey;
    this.props.dispatch(routerRedux.push(`${match.url}/${key}`));
  };
  render() {
    const { match, size, infoes, loading } = this.props;
    const pages = loading ? [] : createPages(match, infoes, size);
    return (
      <Spin spinning={loading} style={{ height: size.height, maxHeight: size.height }}>
        <div className={styles.main} style={{ height: size.height }}>
          <div className={styles.leftMenu}>
            <Tree defaultExpandAll onSelect={this.onSelect(match)}>
              <TreeNode title="前置说明" key="index" />
              <TreeNode title="登录与认证" key="auth" />
              <TreeNode title="作用域" key="domain" />
              <TreeNode title="文件管理" key="file" />
              <TreeNode title="动态接口" key="interface">
                {
                  pages.map(page => (
                    <TreeNode title={page.showName} key={page.key} />
                  ))
                }
              </TreeNode>
              <TreeNode title="错误码" key="error" />
            </Tree>
          </div>
          <div className={styles.contents}>
            <Switch>
              <Route path={`${match.path}/index`} component={md(mdIndex)} />
              <Route path={`${match.path}/auth`} component={md(mdAuth)} />
              <Route path={`${match.path}/domain`} component={md(mdDomain)} />
              <Route path={`${match.path}/file`} component={md(mdFile)} />
              <Route path={`${match.path}/interface`} exact component={md(mdDyInt)} />
              {
                pages.map(page => (
                  <Route key={page.name} path={page.path} render={page.render} />
                ))
              }
              <Route path={`${match.path}/error`} component={md(mdError)} />
            </Switch>
          </div>
        </div>
      </Spin>
    );
  }
}

export default makeAsync({
  batch: true,
  onError: processError,
  asyncProps: {
    infoes: async () => userApi.getAllInterfaceInfoes(),
  },
})(withSize(connect()(DocMainPage)));
