import React from 'react';
import cs from 'classnames';
import ReactMarkdown from 'react-markdown';
import Code from './code';
import styles from './markdown.less';

export default mdString => props => (
  <div style={{
    padding: '1em',
    background: '#fafafa',
  }}
  >
    <ReactMarkdown
      {...props}
      className={cs({
        'markdown-body': true,
        [styles.markdown]: true,
      })}
      source={mdString}
      renderers={{
        code: Code,
      }}
    />
  </div>
);
