import request from '../utils/request';
import post from '../utils/post';
import config from '../utils/config';

export async function fetchMenus() {
  return request(`${config.apiContextPath}/api/configure/user/menus`);
}

export async function fetchModuleInfos() {
  return request(`${config.apiContextPath}/api/module/user/info`);
}

export async function fetchModuleLayout(name) {
  return request(`${config.apiContextPath}/api/module/user/${encodeURIComponent(name)}/layout`);
}


export const adminApi = {
  async allInfoes(dmPath) {
    return request(`${config.apiContextPath}/api/module/admin/info`, { dmPath });
  },
  async getInfo(name, dmPath) {
    return request(`${config.apiContextPath}/api/module/admin/${encodeURIComponent(name)}/info`, { dmPath });
  },
  async getConfigure(name, dmPath) {
    return request(`${config.apiContextPath}/api/module/admin/${encodeURIComponent(name)}/configure`, { dmPath });
  },
  async getPlainConfigure(name, dmPath) {
    return request(`${config.apiContextPath}/api/module/admin/${encodeURIComponent(name)}/plainConfigure`, { dmPath });
  },
  async setConfigure(name, configure, dmPath) {
    return post(`${config.apiContextPath}/api/module/admin/${encodeURIComponent(name)}/configure`, { dmPath, configure });
  },
  async getPlainConfigures(dmPath) {
    return request(`${config.apiContextPath}/api/module/admin/plainConfigures`, { dmPath });
  },
  async setConfigures(configures, dmPath) {
    return post(`${config.apiContextPath}/api/module/admin/configures`, { dmPath, configure: configures });
  },
  async getDocument(name, dmPath) {
    return request(`${config.apiContextPath}/api/module/admin/${encodeURIComponent(name)}/document`, { dmPath });
  },
  async setDocument(name, document, dmPath) {
    return post(`${config.apiContextPath}/api/module/admin/${encodeURIComponent(name)}/document`, { dmPath, document });
  },
};
