/* eslint-disable no-param-reassign */
import isNil from 'lodash/isNil';
import defaults from 'lodash/defaults';
import { fetch } from './polyfill';
import { checkStatus, normParams, parseObject } from './http-helper';
import middleware from './middleware';

const defaultOptions = {
  headers: { Accept: 'application/json' },
};

/**
 * Requests a URL, returning a promise.
 *
 * @param  {string} url       The URL we want to delete
 * @param auth
 * @param params
 * @param  {object} [options] The options we want to pass to "fetch"
 * @return {object}           An object containing either "data" or "err"
 */
export default async function doDelete(url, params = {}, options = {}, auth = true) {
  params = normParams(params);
  const res = await middleware.delete.onRequest(url, params, options, auth);
  let queryParams = (res ? res.params : params).map(([k, v]) => (isNil(v) ? k : `${k}=${encodeURIComponent(v)}`));
  queryParams = queryParams.join('&');
  let realUrl = res ? res.url : url;
  if (queryParams) {
    realUrl = `${url}?${queryParams}`;
  }
  const realOptions = defaults(res ? res.options : options, defaultOptions);
  realOptions.method = 'DELETE';
  return fetch(realUrl, realOptions)
    .then(checkStatus)
    .then(resp => parseObject(resp, middleware.delete.onResponse));
}

