/* eslint-disable no-console */
import React from 'react';
import partial from 'lodash/fp/partial';
import { storiesOf } from '@storybook/react';
import { withInfo } from '@storybook/addon-info';
import ReactMardDown from 'react-markdown';

import ReactJson from 'react-json-view';
import { DatePicker, Form, Input, Modal, Button } from 'antd';

import DsTable from '../src/components/table/dstable';
import TableInput from '../src/components/table/input-table';
import UCA from '../src/components/uca';

import dva from './lib/dva';
import lazy from './lib/lazy';
import loginIt from './lib/login';
import testMd from './test.md';

storiesOf('a', module)
  .add('1', () => {
    const Comp = lazy(partial(loginIt, ['admin', 'admin', '/']))(dva()(DsTable));
    const coordinate = {
      containerType: 'module',
      containerName: 'test',
      datasourceName: 'QueryLeftHousesReturnTable',
    };
    return <Comp coordinate={coordinate} />;
  });

const RangePicker = DatePicker.RangePicker;
storiesOf('antd', module)
  .add('RangePicker', withInfo({ inline: true })(() => {
    return <RangePicker />;
  }))
  .add('uca', withInfo({ inline: true })(() => {
    return <UCA onChange={evt => console.log(evt)} />;
  }));

storiesOf('table-input', module)
  .add('1', () => {
    const Temp = ({ form }) => {
      const props = {
        items: [
          {
            name: 'item0',
            label: 'test0',
          },
          {
            name: 'item1',
            label: 'test1',
          },
        ],
      };
      const handleSubmit = (e) => {
        e.preventDefault();
        form.validateFields((err, values) => {
          if (!err) {
            Modal.info({
              title: '提交内容',
              content: <ReactJson src={values} />,
            });
          }
        });
      };
      return (
        <Form onSubmit={handleSubmit}>
          {
            form.getFieldDecorator('table-input')(
              <TableInput {...props}>
                <Input />
                <Input />
              </TableInput>,
            )
          }
          <Form.Item>
            <Button htmlType="submit">提交</Button>
          </Form.Item>
        </Form>
      );
    };
    const Example = Form.create()(Temp);
    return <Example />;
  });

storiesOf('markdown', module)
  .add('test', () => (<ReactMardDown source={testMd} />));
