import React from 'react';
import { makeCancelable } from '../../src/utils/promise';

export default function (action) {
  return (Comp) => {
    class Lazy extends React.Component {

      constructor() {
        super();
        this.state = {
          loading: true,
        };
      }
      componentDidMount() {
        this.action = makeCancelable(action());
        this.action.run(promise => promise.then(() => {
          this.setState({
            loading: false,
          });
        }));
      }
      componentWillUnmount() {
        this.action.cancel();
      }

      render() {
        if (this.state.loading) {
          return <div>加载中...</div>;
        } else {
          const { children, ...rest } = this.props;
          return (
            <Comp {...rest}>
              { children }
            </Comp>
          );
        }
      }
    }
    return Lazy;
  };
}
