import { authorize, login } from '../../src/services/login';
import { switchDomain } from '../../src/services/domain';
import { encrypt } from '../../src/utils/helper';
import { validate } from '../../src/services/login/password';
import { setToken } from '../../src/utils/auth';

export default async function (userName, password, domainPath) {
  const { tokenId } = await login({ type: 'userName', data: userName });
  const authRequest = await validate(password, encrypt(tokenId));
  await authorize(authRequest);
  await setToken(tokenId);
  if (domainPath) {
    await switchDomain(domainPath);
  }
}
