const { declare } = require('@babel/helper-plugin-utils');

const plugins = [
  'babel-plugin-react-require',
  '@babel/plugin-syntax-dynamic-import',
  '@babel/plugin-proposal-object-rest-spread',
  '@babel/plugin-proposal-optional-catch-binding',
  '@babel/plugin-proposal-async-generator-functions',
  ['@babel/plugin-proposal-decorators', {
    legacy: true,
  }],
  ['@babel/proposal-class-properties', {
    loose: true,
  }],
  '@babel/plugin-proposal-export-namespace-from',
  '@babel/plugin-proposal-export-default-from',
  '@babel/plugin-proposal-nullish-coalescing-operator',
  '@babel/plugin-proposal-optional-chaining',
  '@babel/plugin-proposal-pipeline-operator',
  '@babel/plugin-proposal-do-expressions',
  '@babel/plugin-proposal-function-bind',
  'lodash',
  ['import', { libraryName: 'antd', libraryDirectory: 'es', style: true }],
];

if (process.env.NODE_ENV === 'production') {
  plugins.push(
    'dev-expression',
    '@babel/plugin-transform-react-constant-elements',
    '@babel/plugin-transform-react-inline-elements', // not supported by preact.
    'transform-react-remove-prop-types',
  );
}

if (process.env.NODE_ENV === 'development') {
  plugins.push(
    'dva-hmr',
  );
}

if (process.env.NODE_ENV !== 'test') {
  plugins.push(
    '@babel/plugin-transform-runtime',
  );
}

module.exports = declare(({ assertVersion }, options) => {
  assertVersion(7);
  return {
    presets: [
      [
        '@babel/env',
        {
          targets: {
            browsers: ['ie >= 9'],
          },
          modules: options.modules || false,
          loose: true,
        },
      ],
      '@babel/react',
    ],
    plugins,
  };
});
