/* eslint-disable no-param-reassign,global-require */
const path = require('path');
const webpack = require('webpack');
const CleanWebpackPlugin = require('clean-webpack-plugin');
const CaseSensitivePathsPlugin = require('case-sensitive-paths-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const { existsSync } = require('fs');

const theme = require('./theme');

let hasSassLoader = true;
try {
  require.resolve('sass-loader');
} catch (e) {
  hasSassLoader = false;
}

let supportTS = true;
try {
  require.resolve('typescript');
} catch (e) {
  supportTS = false;
}

const TARGET = process.env.npm_lifecycle_event;
if (!TARGET) {
  // eslint-disable-next-line no-console
  console.log('Please run this script through the npm.');
}
const isDev = TARGET !== 'build';

const outputPath = path.resolve(__dirname, 'dist');

let copyPlugins = [];
if (existsSync(path.resolve(__dirname, 'public'))) {
  copyPlugins = [
    new CopyWebpackPlugin([
      {
        from: path.resolve(__dirname, 'public'),
        to: outputPath,
        toType: 'dir',
      },
    ]),
  ];
}

const cssLoader = module => [
  {
    loader: 'css-loader',
    options: {
      importLoaders: 1,
      ...(isDev
        ? {}
        : {
          minimize: {
            minifyFontValues: false,
          },
          sourceMap: true,
        }),
      ...(!module
        ? {}
        : {
          module,
          localIdentName: isDev
            ? '[name]__[local]___[hash:base64:5]'
            : '[local]___[hash:base64:5]',
        }),
    },
  },
  {
    loader: 'postcss-loader',
    options: {
      ident: 'postcss',
      sourceMap: isDev,
    },
  },
];

const lessLoader = {
  loader: 'less-loader',
  options: {
    modifyVars: theme,
    javascriptEnabled: true,
  },
};

const sassLoader = {
  loader: 'sass-loader',
};

const cssRules = [
  {
    test: /\.css$/,
    exclude: /node_modules/,
    use: [
      // 'style-loader',
      isDev ? 'style-loader' : MiniCssExtractPlugin.loader,
      ...cssLoader(true),
    ],
  },
  {
    test: /\.css$/,
    include: /node_modules/,
    use: [
      // 'style-loader',
      isDev ? 'style-loader' : MiniCssExtractPlugin.loader,
      ...cssLoader(false),
    ],
  },
  {
    test: /\.less$/,
    exclude: /node_modules/,
    use: [
      // 'style-loader',
      isDev ? 'style-loader' : MiniCssExtractPlugin.loader,
      ...cssLoader(true),
      lessLoader,
    ],
  },
  {
    test: /\.less$/,
    include: /node_modules/,
    use: [
      // 'style-loader',
      isDev ? 'style-loader' : MiniCssExtractPlugin.loader,
      ...cssLoader(false),
      lessLoader,
    ],
  },
  ...(!hasSassLoader
    ? []
    : [
      {
        test: /\.sass$/,
        exclude: /node_modules/,
        use: [
          // 'style-loader',
          isDev ? 'style-loader' : MiniCssExtractPlugin.loader,
          ...cssLoader(true),
          sassLoader,
        ],
      },
      {
        test: /\.sass$/,
        include: /node_modules/,
        use: [
          // 'style-loader',
          isDev ? 'style-loader' : MiniCssExtractPlugin.loader,
          ...cssLoader(false),
          sassLoader,
        ],
      },
    ]),
];

const config = {
  context: path.resolve(__dirname),
  entry: {
    main: './src/index.js',
  },
  output: {
    path: outputPath,
  },
  resolve: {
    extensions: [
      '.web.js',
      '.web.jsx',
      '.web.ts',
      '.web.tsx',
      '.js',
      '.json',
      '.jsx',
      '.ts',
      '.tsx',
    ],
    plugins: [
      ...(!supportTS
        ? []
        : [
          new (require('awesome-typescript-loader').TsConfigPathsPlugin)(),
        ]),
    ],
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        enforce: 'pre',
        loader: 'tslint-loader',
        options: {
          emitErrors: true,
        },
      },
      {
        test: /\.(js|jsx)$/,
        exclude: /node_modules/,
        enforce: 'pre',
        loader: 'eslint-loader',
      },
      {
        exclude: [
          /\.(html|ejs)$/,
          /\.json$/,
          /\.(js|jsx|ts|tsx)$/,
          /\.(css|less|scss|sass)$/,
          /\.md$/,
        ],
        loader: 'url-loader',
        options: {
          limit: 8192,
          name: 'static/[name].[hash:8].[ext]',
        },
      },
      {
        test: /\.(js|jsx)$/,
        exclude: /node_modules/,
        use: [
          'cache-loader',
          'babel-loader',
        ],
      },
      {
        test: /\.md$/,
        loader: 'raw-loader',
      },
      ...(!supportTS
        ? []
        : [{
          test: /\.(ts|tsx)$/,
          exclude: /node_modules/,
          use: [
            'cache-loader',
            'babel-loader',
            {
              loader: 'awesome-typescript-loader',
              options: {
                useTranspileModule: true,
              },
            },
          ],
        }]),
      {
        test: /\.html$/,
        loader: 'file-loader',
        options: {
          name: '[name].[ext]',
        },
      },
      ...cssRules,
    ],
  },
  plugins: [
    new CleanWebpackPlugin(['dist']),
    new CaseSensitivePathsPlugin(),
    new webpack.IgnorePlugin(/^\.\/locale$/, /moment$/),
    new HtmlWebpackPlugin({
      template: 'src/index.ejs',
    }),
    new webpack.DefinePlugin({
      'process.env.NODE_ENV': JSON.stringify(process.env.NODE_ENV),
    }),
    ...copyPlugins,
  ],
};

module.exports = config;
