const config = require('./config');
const webpack = require('webpack');
const merge = require('webpack-merge');
const applyMock = require('./tools/applyMock');
const common = require('./webpack.common.js');
const proxy = require('./proxy');
const register = require('./babel-register');
const mock = require('./mock');

register.unregister();

module.exports = merge(common, {
  output: {
    publicPath: config.dev.publicPath,
    filename: '[name].js',
    chunkFilename: '[name].async.js',
    pathinfo: true,
  },
  mode: 'development',
  devtool: 'inline-cheap-source-map',
  devServer: {
    disableHostCheck: true,
    publicPath: config.dev.publicPath,
    hot: true,
    compress: true,
    progress: true,
    historyApiFallback: true,
    proxy,
    headers: {
      'access-control-allow-origin': '*',
    },
    watchOptions: {
      ignored: /node_modules/,
    },
    after(app) {
      applyMock(app, mock);
    },
  },
  plugins: [
    new webpack.HotModuleReplacementPlugin(),
  ],
});
