
require('../babel-register');
const createProxy =  require('http-proxy-middleware');
const _ = require('lodash');
const assert = require('assert');

const roadhog = require('../.webpackrc');
const mock = require('../.roadhogrc.mock');

function parseKey(key) {
  let method = 'get';
  let path = key;

  if (key.indexOf(' ') > -1) {
    const splited = key.split(' ');
    method = splited[0].toLowerCase();
    path = splited[1];
  }

  return { method, path };
}

function makeProxy(method, path, target) {
  const filter = (pathname, req) => {
    return path.test(pathname) && req.method === method.toUpperCase();
  };
  return createProxy(filter, { target });
}

function createMockHandler(value) {
  return function mockHandler(...args) {
    const res = args[1];
    if (typeof value === 'function') {
      value(...args);
    } else {
      res.json(value);
    }
  };
}

module.exports = (router) => {
  const proxy = roadhog.env.development.proxy;
  _.forEach(proxy, (value, key) => {
    router.use(key, createProxy(key, value));
  });
  _.forEach(mock, (value, key) => {
    const parsedkey = parseKey(key);
    assert(
      typeof value === 'function' ||
      typeof value === 'object' ||
      typeof value === 'string',
      `mock value of ${key} should be function or object or string, but got ${typeof value}`
    );
    if (typeof value === 'string') {
      let path = parsedkey.path;
      if (/\(.+\)/.test(parsedkey.path)) {
        path = new RegExp(`^${parsedkey.path}$`);
      }
      router.use(
        path,
        makeProxy(parsedkey.method, path, value)
      );
    } else {
      router[parsedkey.method](
        parsedkey.path,
        createMockHandler(value)
      );
    }
  })
};
