const genDefaultConfig = require('@storybook/react/dist/server/config/defaults/webpack.config.js').default;
const path = require('path').default;

module.exports = (baseConfig, env) => {
  const config = genDefaultConfig(baseConfig, env);

  // Extend it as you need.

  // For example, add typescript loader:
  config.module.rules.push({
    test: /\.less$/,
    include: path.resolve(__dirname, '../src'),
    use: [
      require.resolve('style-loader'),
      {
        loader: require.resolve('css-loader'),
        options: {
          modules: true,
        },
      },
      require.resolve('less-loader')
    ],
  }, {
    test: /\.less$/,
    exclude: path.resolve(__dirname, '../src'),
    use: [
      require.resolve('style-loader'),
      require.resolve('css-loader'),
      require.resolve('less-loader')
    ],
  });

  return config;
};
