import React from 'react';
import PropTypes from 'prop-types';
import { Form, Select, Button } from 'antd';
import { connect } from 'dva';
import styles from './index.less';

const FormItem = Form.Item;

class Domain extends React.Component {

  constructor(props, context) {
    super(props, context);
    this.handleSubmit = this::this.handleSubmit;
  }

  componentDidMount() {
    this.props.dispatch({ type: 'domain/fetch' });
  }

  handleSubmit(e) {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'domain/switch',
          payload: values.domain,
        });
      }
    });
  }

  render() {
    const { form, domain, loading } = this.props;
    const currentDomain = domain.init;
    const selectOptions = {};
    const decoratorOptions = {
      rules: [
        { required: true },
      ],
    };
    if (!currentDomain) {
      selectOptions.placeholder = '请选择项目...';
    } else {
      decoratorOptions.initialValue = currentDomain;
    }
    return (
      <div className={styles.canvas}>
        <div className={styles.container}>
          <Form onSubmit={this.handleSubmit}>
            <FormItem>
              {
                form.getFieldDecorator('domain', decoratorOptions)(
                  <Select {...selectOptions}>
                    {domain.list.map(({ path, name }) => {
                      return <Select.Option value={path} key={path}>{name}</Select.Option>;
                    })}
                  </Select>,
                )
              }
            </FormItem>
            <FormItem>
              <Button type="primary" htmlType="submit" className={styles.submit} loading={loading}>
                确定
              </Button>
            </FormItem>
          </Form>
        </div>
      </div>
    );
  }
}

Domain.propTypes = {
  domain: PropTypes.object,
  loading: PropTypes.bool,
  form: PropTypes.object,
};

const mapStateToProps = ({ domain, loading }) => {
  return {
    domain,
    loading: loading.effects['domain/switch'],
  };
};

export default connect(mapStateToProps)(Form.create()(Domain));

