/**
 * Created by yaohx_169 on 2017/6/5.
 */
import React from 'react';
import PropTypes from 'prop-types';
import { Form, Icon, Input, Checkbox, Button } from 'antd';
import { connect } from 'dva';
import AuthInputs from './authInput';
import UCA from '../../components/uca';
import config from '../../utils/config';
import styles from './index.less';

class LoginForm extends React.Component {

  componentDidMount() {
    this.props.dispatch({ type: 'login/init' });
  }


  onUserBlur = (e) => {
    const { value } = e.target;
    if (value) {
      this.props.dispatch({ type: 'login/login', payload: value });
    }
  };
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        if (this.props.login.status === 'login') {
          this.authFocus = true;
          this.props.dispatch({ type: 'login/login', payload: values.userName });
        } else if (this.props.login.status === 'auth') {
          this.props.dispatch({ type: 'login/auth', payload: values });
        }
      }
    });
  };
  createPassword = (focus = false) => {
    const { getFieldDecorator } = this.props.form;
    return getFieldDecorator('password', {
      rules: [{
        required: true,
        message: '请输入密码。',
      }],
    })(
      <Input autoFocus={focus} prefix={<Icon type="lock" />} type="password" placeholder="密码" />,
    );
  };
  createUCA = (focus = false) => {
    const { form, login } = this.props;
    const { getFieldDecorator } = form;
    return getFieldDecorator('uca', {
      rules: [{
        required: true,
        message: '请输入usb-key的密钥。',
      }],
    })(
      <UCA autoFocus={focus} loading={!login.ucaCode} data={login.ucaCode} prefix={<Icon type="hdd" placeholder="密钥" />} />,
    );
  };
  createValidates = () => {
    const { login } = this.props;
    if (login.status === 'login') {
      return [];
    } else if (login.status === 'auth') {
      const { authRequires } = login;
      return authRequires.map((authRequire) => {
        const pass = authRequire.indexOf('password') !== -1;
        const uca = authRequire.indexOf('uca') !== -1;
        let focus = false;
        if (pass || uca) {
          if (this.authFocus) {
            focus = true;
            this.authFocus = false;
          }
        }
        if (pass && uca) {
          return (
            <Form.Item key="passOrUca">
              <AuthInputs
                data={[
                  {
                    key: 'password',
                    label: '密码',
                    node: () => this.createPassword(focus),
                  },
                  {
                    key: 'uca',
                    label: '证书',
                    node: () => this.createUCA(focus),
                  },
                ]}
              />
            </Form.Item>
          );
        } else if (pass) {
          return (
            <Form.Item key="pass">
              { this.createPassword(focus) }
            </Form.Item>
          );
        } else if (uca) {
          return (
            <Form.Item key="uca">
              { this.createUCA(focus) }
            </Form.Item>
          );
        } else {
          return <Form.Item />;
        }
      });
    }
  };

  render() {
    const { getFieldDecorator } = this.props.form;
    const { loading } = this.props;
    return (
      <div className={styles.canvas}>
        <div className={styles.container}>
          <div className={styles.logo}>
            <img alt="logo" src={config.logo} />
            <span>{config.name}</span>
          </div>
          <Form onSubmit={this.handleSubmit}>
            <Form.Item>
              {
                getFieldDecorator('userName', {
                  initialValue: this.props.login.userName,
                  rules: [{
                    required: true,
                    message: '请输入用户名。',
                  }],
                })(
                  <Input
                    autoFocus={!this.authFocus}
                    onBlur={this.onUserBlur}
                    prefix={<Icon type="user" />}
                    placeholder="用户名"
                    onChange={() => {
                      this.props.dispatch({ type: 'login/setStatus', payload: 'login' });
                    }}
                  />,
                )
              }
            </Form.Item>
            {
              this.createValidates()
            }
            <Form.Item>
              {
                getFieldDecorator('remember', {
                  valuePropName: 'checked',
                  initialValue: true,
                })(
                  <Checkbox>记住我</Checkbox>,
                )
              }
              <a className={styles.forgot} href="">忘记密码</a>
              <Button type="primary" htmlType="submit" className={styles.submit} loading={loading}>
                登录
              </Button>
              或者<a>现在注册！</a>
            </Form.Item>
          </Form>
        </div>
      </div>
    );
  }

}

LoginForm.propTypes = {
  form: PropTypes.object,
  loading: PropTypes.bool,
  dispatch: PropTypes.func,
};

const mapStateToProps = ({ login, loading }) => {
  return {
    login,
    loading: loading.effects['login/login'],
  };
};

export default connect(mapStateToProps)(Form.create()(LoginForm));
