import React from 'react';
import PropTypes from 'prop-types';
import { Menu, Breadcrumb, Icon } from 'antd';
import { connect } from 'dva';
import { Link } from 'dva-react-router-3/router';
import styles from './header.less';

const SubMenu = Menu.SubMenu;

class HeaderPane extends React.Component {

  componentDidMount() {
    const { dispatch } = this.props;
    dispatch({ type: 'main/fetchUser' });
    dispatch({ type: 'main/fetchDomain' });
    dispatch({ type: 'main/fetchDomains' });
  }
  render() {
    const { dispatch, user, domain, domainList, routes, params } = this.props;
    const userTitle = (
      <span>
        <Icon type="user" />
        { user }
      </span>
    );
    const domainTitle = (
      <span>
        <Icon type="home" />
        { domain }
      </span>
    );
    const onClick = ({ keyPath }) => {
      if (keyPath[1] === 'user' && keyPath[0] === 'logout') {
        dispatch({ type: 'main/logout' });
      } else if (keyPath[1] === 'domain') {
        dispatch({ type: 'main/switchDomain', payload: keyPath[0] });
      }
    };
    const joinPath = (paths) => {
      return (paths || []).map((path) => {
        let out = path;
        if (out.startsWith('/')) {
          out = out.substring(1);
        }
        if (out.endsWith('/')) {
          out = out.substring(0, out.length - 1);
        }
        return out;
      }).join('/');
    };
    const breadsProps = {
      className: styles.breads,
      routes,
      params,
      itemRender(route, _params, _routes, paths) {
        if (!paths || !paths.length) {
          return null;
        }
        if (paths.length === 1) {
          return <Icon type="home" />;
        }
        const bread = route.name ? route.name : route.path;
        return <Link to={`/${joinPath(paths)}`}>{ bread }</Link>;
      },
    };
    const menuProps = {
      className: styles.menu,
      mode: 'horizontal',
      theme: 'light',
      selectable: false,
      onClick,
    };
    return (
      <div className={styles.board}>
        <Breadcrumb {...breadsProps} />
        <Menu {...menuProps}>
          <SubMenu title={userTitle} key="user" >
            <Menu.Item key="logout">
              <span>
                <Icon type="logout" />
                登出
              </span>
            </Menu.Item>
          </SubMenu>
          <SubMenu title={domainTitle} key="domain">
            {
              domainList.map(dm => (
                <Menu.Item key={dm.path}>
                  { dm.name }
                </Menu.Item>
              ))
            }
          </SubMenu>
        </Menu>
      </div>
    );
  }
}

HeaderPane.propTypes = {
  dispatch: PropTypes.func,
  user: PropTypes.string,
  domain: PropTypes.string,
  domainList: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.number,
    name: PropTypes.string,
  })),
};

const mapStateToProps = ({ main }) => {
  return {
    user: main.user,
    domain: main.domain,
    domainList: main.domainList,
  };
};

export default connect(mapStateToProps)(HeaderPane);

