import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'dva';
import { withRouter } from 'dva-react-router-3/router';
import { Layout } from 'antd';
import SiderLogo from '../../components/layout/sider/SiderLogo';
import SiderMenu from '../../components/layout/sider/SiderMenu';
import HeaderPane from './header';
import { thisPush } from '../../services/route';
import styles from './index.less';

const { Sider, Header, Content, Footer } = Layout;

class Main extends React.Component {

  constructor(props, context) {
    super(props, context);
    this.onClick = this::this.onClick;
    this.onCollapse = this::this.onCollapse;
    this.state = {
      collapsed: false,
      mode: 'inline',
    };
  }
  componentDidMount() {
    this.props.dispatch({ type: 'main/fetchModules' });
  }
  onClick({ keyPath }) {
    const paths = keyPath.reverse().join('/');
    thisPush(this, `/main/${paths}`);
    // this.props.dispatch(routerRedux.push(fullPath(`/main/${paths}`)));
  }
  onCollapse(collapsed) {
    this.setState({
      collapsed,
      mode: collapsed ? 'vertical' : 'inline',
    });
  }
  render() {
    const { main, children } = this.props;
    const { menus } = main;
    const mode = this.state.mode;
    const menuProps = {
      mode,
      menus,
      onClick: this.onClick,
    };
    const { routes, params } = this.props;
    const headerProps = {
      routes,
      params,
      menus,
    };
    return (
      <Layout className={styles.layout}>
        <Sider collapsible collapsed={this.state.collapsed} onCollapse={this.onCollapse}>
          <SiderLogo />
          <SiderMenu {...menuProps} />
        </Sider>
        <Layout>
          <Header>
            <HeaderPane {...headerProps} />
          </Header>
          <Content>
            { children }
          </Content>
          <Footer>
            <span className={styles.company}>®上海铂蓝信息科技有限公司</span>
          </Footer>
        </Layout>
      </Layout>
    );
  }

}

Main.propTypes = {
  children: PropTypes.element,
  main: PropTypes.object,
};

export default connect(({ main }) => ({ main }))(withRouter(Main));
