import _, { partial } from 'lodash';
import request from '../utils/request';
import post from '../utils/post';
import doDelete from '../utils/delete';
import config from '../utils/config';

// noinspection JSUnusedGlobalSymbols
export const templateApi = (dmPath) => {
  return {
    admin: {
      getInfo: partial(getAdminTemplateInfo, _, dmPath),
      getAllInfoes: partial(getAllAdminTemplateInfoes, dmPath),
      getConfigure: partial(getAdminTemplateConfigure, _, dmPath),
      getPlainConfigure: partial(getAdminTemplatePlainConfigure, _, dmPath),
      setConfigure: partial(setAdminTemplateConfigure, _, _, dmPath),
      removeConfigure: partial(removeAdminTemplateConfigure, _, dmPath),
      getTemplate: partial(getAdminTemplateTemplate, _, dmPath),
      setTemplate: partial(setAdminTemplateTemplate, _, _, dmPath),
      render: partial(adminRender, _, _, _, dmPath),
    },
  };
};

export async function getAllAdminTemplateInfoes(dmPath) {
  return request(`${config.apiContextPath}/api/template/admin/info`, { dmPath });
}

export async function getAdminTemplateInfo(name, dmPath) {
  return request(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/info`, { dmPath });
}

export async function getAdminTemplateConfigure(name, dmPath) {
  return request(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/configure`, { dmPath });
}

export async function getAdminTemplatePlainConfigure(name, dmPath) {
  return request(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/plainConfigure`, { dmPath });
}

export async function setAdminTemplateConfigure(name, configure, dmPath) {
  return post(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/configure`, { configure, dmPath });
}

export async function removeAdminTemplateConfigure(name, dmPath) {
  return doDelete(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/configure`, { dmPath });
}

export async function setAdminTemplateTemplate(name, uri, dmPath) {
  return post(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/template`, { uri, dmPath });
}

export async function getAdminTemplateTemplate(name, dmPath) {
  return request(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/template`, { dmPath });
}

export async function adminRender(name, params, mediaType, dmPath) {
  return post(`${config.apiContextPath}/api/template/admin/${encodeURIComponent(name)}/render`, { dmPath, mediaType, params });
}
